#ifndef _ATTRIBUTESRECT_H
#define _ATTRIBUTESRECT_H

#include <QtGui>

class Attribute;
class Table;

class AttributesRect : public QGraphicsRectItem
{
	public:
		AttributesRect(QRectF& rect, QGraphicsItem * parent = 0);
		virtual ~AttributesRect();

	public:
		void SetPosition(int length);
		void InsertAttribute();
		void DeleteAttribute();
		void SetRect(int state);
		void DeleteAttribute(Attribute* attribute);
		void InsertAttribute(QString name);
		void InsertAttribute(QStringList &list);
		void DeleteAttribute(QStringList& foreignKeyList, QList<Attribute*>& list);

	public:
		QList<Attribute*> GetAttributes() const;
		Table* table;

	private:
		QRectF rect;
		QList<Attribute*> attributes;
};

inline QList<Attribute*> AttributesRect::GetAttributes() const
{
	return this->attributes;
}

#endif //_ATTRIBUTESRECT_H
